<!--**********************************Table AllTransaction Start***********************************-->

@if (session()->has('import_errors'))

    <table class="table table-danger">
        <thead>
            <p class="fw-bold text-center text-danger bg-warning-light p-3 m-0"> لم يتم الاستيراد يرجى مراجعة البيانات في
                ملف الاكسل وتصحيح الاخطاء في كل من :
            </p>
        </thead>
        <tr>
            <th>الصف</th>
            <th>العمود</th>
            <th>الخطاء</th>
            <th>القيمة المرسلة</th>
            <th> المتدرب</th>
        </tr>

        @foreach (session()->get('import_errors') as $validation)
            <tr>
                <td>{{ $validation->row() }}</td>
                <td>{{ $validation->attribute() }}</td>
                <td>
                    <ul>
                        @foreach ($validation->errors() as $e)
                            <li>{{ $e }}</li>
                        @endforeach
                    </ul>
                </td>
                <td>
                    {{ $validation->values()[$validation->attribute()] }}
                </td>
                <td>
                    {{ $validation->values()['name'] }}
                </td>
            </tr>
        @endforeach
    </table>

@endif
<div class="tab-pane fade show active" id="AllTransaction" role="tabpanel" aria-labelledby="transaction-tab">
    <div class="table-responsive fs-14">
        <table class="table card-table display mb-4 dataTablesCard text-black text-center" id="example">
            <thead>
                <tr>
                    <th>رقم </th>
                    <th>اسم متدرب</th>
                    <th>الاسم المطلوب للشهادة</th>
                    <th>الإيميل</th>
                    <th>رقم الجوال</th>
                    <th>الحالة</th>
                    <th>العمليات</th>
                </tr>
            </thead>
            <tbody>
                @isset($students)
                    @foreach ($students as $student)
                        <tr class="odd" role="row">
                            <td>
                                @isset($student)
                                    {{ $loop->iteration }}
                                @endisset
                            </td>
                            <td>
                                @isset($student->name)
                                    {{ $student->name }}
                                @endisset
                            </td>
                            <td>
                                @isset($student->certificate_name)
                                    {{ $student->certificate_name }}
                                @endisset
                            </td>
                            <td>
                                @isset($student->email)
                                    {{ $student->email }}
                                @endisset
                            </td>
                            <td>
                                @isset($student->phone)
                                    {{ $student->phone }}
                                @endisset
                            </td>

                            <td>
                                @isset($student->is_active)
                                    @if ($student->is_active == 1)
                                        <span class="badge badge-success light">نشط</span>
                                    @else
                                        <span class="badge badge-danger light">غير نشط</span>
                                    @endif
                                @endisset
                            </td>
                            <td>
                                <div class="dropdown dropstart">
                                    <a href="javascript:void(0);" class="btn-link" data-bs-toggle="dropdown"
                                        aria-expanded="false">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M12 13C12.5523 13 13 12.5523 13 12C13 11.4477 12.5523 11 12 11C11.4477 11 11 11.4477 11 12C11 12.5523 11.4477 13 12 13Z"
                                                stroke="#575757" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                            <path
                                                d="M12 6C12.5523 6 13 5.55228 13 5C13 4.44772 12.5523 4 12 4C11.4477 4 11 4.44772 11 5C11 5.55228 11.4477 6 12 6Z"
                                                stroke="#575757" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                            <path
                                                d="M12 20C12.5523 20 13 19.5523 13 19C13 18.4477 12.5523 18 12 18C11.4477 18 11 18.4477 11 19C11 19.5523 11.4477 20 12 20Z"
                                                stroke="#575757" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                        </svg>
                                    </a>
                                    <div class="dropdown-menu">
                                        <button type="button" value=""
                                            data-id="@isset($student->id){{ $student->id }} @endisset"
                                            data-name="@isset($student->name){{ $student->name }}@endisset"
                                            data-certificate_name="@isset($student->certificate_name){{ $student->certificate_name }}@endisset"
                                            data-email="@isset($student->email){{ $student->email }}@endisset"
                                            data-phone="@isset($student->phone){{ $student->phone }}@endisset"
                                            
                                            data-type="1" class="edit dropdown-item" href=" transaction-details.html"><i
                                                class="bi bi-pencil-square text-success ms-3"></i>تعديل </button>
                                        <button type="button" value="" data-id="{{ $student->id }}"
                                            data-is_active="{{ $student->is_active }}" data-title="المتدرب"
                                            data-route='{{ route('student_toggle') }}' class="toggle dropdown-item"
                                            href="toggle ">
                                            @if ($student->is_active == 1)
                                                <i class="bi bi-eye-slash-fill fa-trash ms-3 text-danger"></i>تعليق
                                            @else
                                                <i class="bi bi-eye-fill ms-3 text-success"></i>تفعيل
                                            @endif
                                        </button>
                                        <button type="button" data-route="{{ route('student_delete') }}"
                                            data-id="@isset($student->id){{ $student->id }}@endisset"
                                            class=" delete-item   dropdown-item" href="toggle "><i
                                                class="fa fa-trash ms-3 text-danger"></i>حذف</button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                @endisset
            </tbody>
        </table>
    </div>
</div>
<!--**********************************Table AllTransaction End***********************************-->
